#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// 3_2 - Circles pt_2Mod01.fsh   by   retonym   
//https://www.shadertoy.com/view/mdByWw
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// palette
const vec3 darkblue = vec3(0.0, 0.0, 0.2);
const vec3 orange = vec3(0.8, 0.6, 0.2);
const vec3 black = vec3(0.0);
const vec3 white = vec3(1.0);

vec3 featheredRing(vec2 center, float radius, float ringWidth, float featherAmt, vec3 color, vec2 uv)
{
    vec2 toCenter = center-uv;
    float outerCircle = smoothstep(radius, radius - featherAmt, length(toCenter));
    float innerCircle = smoothstep(radius - ringWidth, radius - ringWidth - featherAmt, length(toCenter)); 
    float ring = outerCircle - innerCircle;
    
    vec3 coloredRing = vec3(ring) * (1.0 - color);
    coloredRing = 1.0 - coloredRing;

    return coloredRing;
}

vec3 raindrop(vec2 center, float timeOffset, vec2 uv)
{ 
    float speed = .8;
    float raindropLifetime = pow(fract(iTime + timeOffset), 0.4);
    
    float radius = .3;
    radius *= raindropLifetime;
    
    vec3 fadingColor = mix(orange, black, raindropLifetime); 
    
    float ringWidth = 0.1;
    ringWidth = mix(ringWidth, 0.0, raindropLifetime);
    
    float featherAmt = .14;
    featherAmt = mix(featherAmt, featherAmt - .1, raindropLifetime);
    
    
    vec3 raindrop = featheredRing(center, radius, ringWidth, featherAmt, fadingColor, uv);    
    
    return 1.0 - raindrop;
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    // trying to set up a square uv space similar to the bookofshaders tutorial setup
    vec2 uv = vec2(0.0, 0.0);
    float screenRatio = iResolution.x/iResolution.y;
    uv.x = (fragCoord.x/iResolution.x) * screenRatio;
    uv.y = fragCoord.y/iResolution.y;
    
    
    // included demo of combining distance fields
    float pct = 0.0;
    //pct = distance(uv,vec2(0.4)) + distance(uv,vec2(0.6));
    pct = distance(uv,vec2(0.2)) * distance(uv,vec2(0.7));
    //pct = min(distance(uv,vec2(0.4)),distance(uv,vec2(0.6)));
    //pct = max(distance(uv,vec2(0.4)),distance(uv,vec2(0.6)));
    //pct = pow(distance(uv,vec2(0.4)),distance(uv,vec2(0.6)));
    
    // exercise 1 - make a composition of some kind using this method (include animation)
    
    // raindrops could be fun...
    // can get a feathered ring by subtracting a feathered circle from another feathered circle.
    // write a function to do that.
    

    // raindrops

    // "array" of preset positions bc i don't know how to do randomization :')
    vec2 pos1 = vec2(.2, .5);
    vec2 pos2 = vec2(.5, .2);
    vec2 pos3 = vec2(.8, .1);
    vec2 pos4 = vec2(.45, .64);
    vec2 pos5 = vec2( .8, .74);
    vec2 pos6 = vec2(.94, .56);
    vec2 pos7 = vec2(1.3, .28);
    vec2 pos8 = vec2(1.5, .1);
    vec2 pos9 = vec2(1.45, .84);
    vec2 pos10 = vec2(1.15, .7);

  
    vec3 rain = raindrop(pos1, .5, uv) + darkblue;
    rain += raindrop(pos2, .14, uv);
    rain += raindrop(pos3, .86, uv);
    rain += raindrop(pos4, .33, uv);
    rain += raindrop(pos5, .02, uv);
    rain += raindrop(pos6, .55, uv);
    rain += raindrop(pos7, .65, uv);
    rain += raindrop(pos8, .18, uv);
    rain += raindrop(pos9, .39, uv);
    rain += raindrop(pos10, .5, uv);
    
    fragColor = vec4(rain, 1.0);             

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

